# -------------------------------------------------------- 
# SharePoint 2013 Advanced WCM - Sample Code 
# by John Chapman
# (c) Packt Publishing
#
# Configure versioning on the Pages library
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# VARIABLES
# Replace the variable values appropriately
# -------------------------------------------------------- 

# URL to the SharePoint site
$webUrl = "http://sharepoint/site"

# -------------------------------------------------------- 
# END VARIABLES
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# SCRIPT
# -------------------------------------------------------- 

# Add the SharePoint PowerShell snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

# Get the SharePoint Site
$web = Get-SPWeb $webUrl

# Get the Pages Library
$pages = $web.Lists["Pages"]

# Enable Versioning
$pages.EnableVersioning = $true
$pages.EnableMinorVersions = $true
	
# Add limits to the number of major and minor versions
$pages.MajorWithMinorVersionsLimit = 25
$pages.MajorVersionLimit = 25

# Configure who can see draft items
$pages.DraftVersionVisibility = [Microsoft.SharePoint.DraftVisibilityType]::Author

# Require items to be checked-out before being able to edit them
$pages.ForceCheckout = $true

# Update the Pages Library
$pages.Update()

# Dispose of the site object
$web.Dispose()

# -------------------------------------------------------- 
# END SCRIPT
# -------------------------------------------------------- 